#ifndef CUFFTDX_FFT_2401_FP64_INV_PTX_HPP
#define CUFFTDX_FFT_2401_FP64_INV_PTX_HPP



template<> __forceinline__ __device__ void cufftdx_private_function<722, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<27>;
.reg .f64 fd<623>;
.reg .b64 rd<17>;
mov.u32 r1, %tid.y;
mov.u32 r2, %14;
mad.lo.s32 r3, r1, 38416, r2;
mov.u32 r4, %tid.x;
add.f64 fd29, %20, %34;
add.f64 fd30, %18, fd29;
add.f64 fd31, %23, %31;
add.f64 fd32, fd31, fd30;
add.f64 fd33, %26, %28;
add.f64 fd34, %22, %35;
add.f64 fd35, %19, fd34;
add.f64 fd36, %25, %33;
add.f64 fd37, fd36, fd35;
add.f64 fd38, %27, %30;
fma.rn.f64 fd39, fd29, 0d3FE3F3A0E28BEDD1, %18;
mul.f64 fd40, fd31, 0d3FCC7B90E3024582;
sub.f64 fd41, fd39, fd40;
mul.f64 fd42, fd33, 0d3FECD4BCA9CB5C71;
sub.f64 fd43, fd41, fd42;
sub.f64 fd44, %22, %35;
mul.f64 fd45, fd44, 0d3FE904C37505DE4B;
sub.f64 fd46, %25, %33;
fma.rn.f64 fd47, fd46, 0d3FEF329C0558E969, fd45;
sub.f64 fd48, %27, %30;
fma.rn.f64 fd49, fd48, 0d3FDBC4C04D71ABC1, fd47;
sub.f64 fd50, fd43, fd49;
add.f64 fd51, fd49, fd43;
mul.f64 fd52, fd29, 0d3FCC7B90E3024582;
sub.f64 fd53, %18, fd52;
mul.f64 fd54, fd31, 0d3FECD4BCA9CB5C71;
sub.f64 fd55, fd53, fd54;
fma.rn.f64 fd56, fd33, 0d3FE3F3A0E28BEDD1, fd55;
mul.f64 fd57, fd44, 0d3FEF329C0558E969;
mul.f64 fd58, fd46, 0d3FDBC4C04D71ABC1;
sub.f64 fd59, fd57, fd58;
mul.f64 fd60, fd48, 0d3FE904C37505DE4B;
sub.f64 fd61, fd59, fd60;
sub.f64 fd62, fd56, fd61;
add.f64 fd63, fd61, fd56;
mul.f64 fd64, fd29, 0d3FECD4BCA9CB5C71;
sub.f64 fd65, %18, fd64;
fma.rn.f64 fd66, fd31, 0d3FE3F3A0E28BEDD1, fd65;
mul.f64 fd67, fd33, 0d3FCC7B90E3024582;
sub.f64 fd68, fd66, fd67;
mul.f64 fd69, fd44, 0d3FDBC4C04D71ABC1;
mul.f64 fd70, fd46, 0d3FE904C37505DE4B;
sub.f64 fd71, fd69, fd70;
fma.rn.f64 fd72, fd48, 0d3FEF329C0558E969, fd71;
sub.f64 fd73, fd68, fd72;
add.f64 fd74, fd72, fd68;
fma.rn.f64 fd75, fd34, 0d3FE3F3A0E28BEDD1, %19;
mul.f64 fd76, fd36, 0d3FCC7B90E3024582;
sub.f64 fd77, fd75, fd76;
mul.f64 fd78, fd38, 0d3FECD4BCA9CB5C71;
sub.f64 fd79, fd77, fd78;
sub.f64 fd80, %20, %34;
mul.f64 fd81, fd80, 0d3FE904C37505DE4B;
sub.f64 fd82, %23, %31;
fma.rn.f64 fd83, fd82, 0d3FEF329C0558E969, fd81;
sub.f64 fd84, %26, %28;
fma.rn.f64 fd85, fd84, 0d3FDBC4C04D71ABC1, fd83;
add.f64 fd86, fd85, fd79;
sub.f64 fd87, fd79, fd85;
mul.f64 fd88, fd34, 0d3FCC7B90E3024582;
sub.f64 fd89, %19, fd88;
mul.f64 fd90, fd36, 0d3FECD4BCA9CB5C71;
sub.f64 fd91, fd89, fd90;
fma.rn.f64 fd92, fd38, 0d3FE3F3A0E28BEDD1, fd91;
mul.f64 fd93, fd80, 0d3FEF329C0558E969;
mul.f64 fd94, fd82, 0d3FDBC4C04D71ABC1;
sub.f64 fd95, fd93, fd94;
mul.f64 fd96, fd84, 0d3FE904C37505DE4B;
sub.f64 fd97, fd95, fd96;
add.f64 fd98, fd97, fd92;
sub.f64 fd99, fd92, fd97;
mul.f64 fd100, fd34, 0d3FECD4BCA9CB5C71;
sub.f64 fd101, %19, fd100;
fma.rn.f64 fd102, fd36, 0d3FE3F3A0E28BEDD1, fd101;
mul.f64 fd103, fd38, 0d3FCC7B90E3024582;
sub.f64 fd104, fd102, fd103;
mul.f64 fd105, fd80, 0d3FDBC4C04D71ABC1;
mul.f64 fd106, fd82, 0d3FE904C37505DE4B;
sub.f64 fd107, fd105, fd106;
fma.rn.f64 fd108, fd84, 0d3FEF329C0558E969, fd107;
add.f64 fd109, fd108, fd104;
sub.f64 fd110, fd104, fd108;
mul.wide.u32 rd2, r4, -1089394037;
shr.u64 rd3, rd2, 40;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 343;
sub.s32 r7, r4, r6;
mad.lo.s32 r8, r5, 38416, r3;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %15;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd111, fd112}, [rd6];
mul.f64 fd115, fd86, fd112;
mul.f64 fd116, fd50, fd112;
mul.f64 fd117, fd111, fd86;
mul.f64 fd118, fd111, fd111;
mul.f64 fd119, fd112, fd112;
sub.f64 fd120, fd118, fd119;
mul.f64 fd121, fd112, fd111;
fma.rn.f64 fd122, fd112, fd111, fd121;
mul.f64 fd123, fd98, fd122;
mul.f64 fd124, fd62, fd122;
mul.f64 fd125, fd120, fd98;
mul.f64 fd126, fd111, fd120;
mul.f64 fd127, fd112, fd122;
sub.f64 fd128, fd126, fd127;
mul.f64 fd129, fd111, fd122;
fma.rn.f64 fd130, fd112, fd120, fd129;
mul.f64 fd131, fd109, fd130;
mul.f64 fd132, fd73, fd130;
mul.f64 fd133, fd128, fd109;
ld.global.v2.f64 {fd134, fd135}, [rd6+5488];
mul.f64 fd138, fd110, fd135;
mul.f64 fd139, fd74, fd135;
mul.f64 fd140, fd134, fd110;
mul.f64 fd141, fd111, fd134;
mul.f64 fd142, fd112, fd135;
sub.f64 fd143, fd141, fd142;
mul.f64 fd144, fd111, fd135;
fma.rn.f64 fd145, fd112, fd134, fd144;
mul.f64 fd146, fd99, fd145;
mul.f64 fd147, fd63, fd145;
mul.f64 fd148, fd143, fd99;
mul.f64 fd149, fd111, fd143;
mul.f64 fd150, fd112, fd145;
sub.f64 fd151, fd149, fd150;
mul.f64 fd152, fd111, fd145;
fma.rn.f64 fd153, fd112, fd143, fd152;
mul.f64 fd154, fd87, fd153;
mul.f64 fd155, fd51, fd153;
mul.f64 fd156, fd151, fd87;
barrier.sync 0;
mad.lo.s32 r9, r7, 112, r8;
add.f64 fd157, fd38, fd37;
add.f64 fd158, fd33, fd32;
st.shared.v2.f64 [r9], {fd158, fd157};
fma.rn.f64 fd159, fd111, fd50, fd115;
sub.f64 fd160, fd117, fd116;
st.shared.v2.f64 [r9+16], {fd159, fd160};
fma.rn.f64 fd161, fd120, fd62, fd123;
sub.f64 fd162, fd125, fd124;
st.shared.v2.f64 [r9+32], {fd161, fd162};
sub.f64 fd163, fd133, fd132;
fma.rn.f64 fd164, fd128, fd73, fd131;
st.shared.v2.f64 [r9+48], {fd164, fd163};
fma.rn.f64 fd165, fd134, fd74, fd138;
sub.f64 fd166, fd140, fd139;
st.shared.v2.f64 [r9+64], {fd165, fd166};
fma.rn.f64 fd167, fd143, fd63, fd146;
sub.f64 fd168, fd148, fd147;
st.shared.v2.f64 [r9+80], {fd167, fd168};
sub.f64 fd169, fd156, fd155;
fma.rn.f64 fd170, fd151, fd51, fd154;
st.shared.v2.f64 [r9+96], {fd170, fd169};
barrier.sync 0;
mad.lo.s32 r10, r7, -96, r9;
ld.shared.v2.f64 {fd171, fd172}, [r10];
ld.shared.v2.f64 {fd175, fd176}, [r10+5488];
ld.shared.v2.f64 {fd179, fd180}, [r10+10976];
ld.shared.v2.f64 {fd183, fd184}, [r10+16464];
ld.shared.v2.f64 {fd187, fd188}, [r10+21952];
ld.shared.v2.f64 {fd191, fd192}, [r10+27440];
ld.shared.v2.f64 {fd195, fd196}, [r10+32928];
add.f64 fd199, fd175, fd195;
add.f64 fd200, fd171, fd199;
add.f64 fd201, fd179, fd191;
add.f64 fd202, fd201, fd200;
add.f64 fd203, fd183, fd187;
add.f64 fd204, fd176, fd196;
add.f64 fd205, fd172, fd204;
add.f64 fd206, fd180, fd192;
add.f64 fd207, fd206, fd205;
add.f64 fd208, fd184, fd188;
fma.rn.f64 fd209, fd199, 0d3FE3F3A0E28BEDD1, fd171;
mul.f64 fd210, fd201, 0d3FCC7B90E3024582;
sub.f64 fd211, fd209, fd210;
mul.f64 fd212, fd203, 0d3FECD4BCA9CB5C71;
sub.f64 fd213, fd211, fd212;
sub.f64 fd214, fd176, fd196;
mul.f64 fd215, fd214, 0d3FE904C37505DE4B;
sub.f64 fd216, fd180, fd192;
fma.rn.f64 fd217, fd216, 0d3FEF329C0558E969, fd215;
sub.f64 fd218, fd184, fd188;
fma.rn.f64 fd219, fd218, 0d3FDBC4C04D71ABC1, fd217;
sub.f64 fd220, fd213, fd219;
add.f64 fd221, fd219, fd213;
mul.f64 fd222, fd199, 0d3FCC7B90E3024582;
sub.f64 fd223, fd171, fd222;
mul.f64 fd224, fd201, 0d3FECD4BCA9CB5C71;
sub.f64 fd225, fd223, fd224;
fma.rn.f64 fd226, fd203, 0d3FE3F3A0E28BEDD1, fd225;
mul.f64 fd227, fd214, 0d3FEF329C0558E969;
mul.f64 fd228, fd216, 0d3FDBC4C04D71ABC1;
sub.f64 fd229, fd227, fd228;
mul.f64 fd230, fd218, 0d3FE904C37505DE4B;
sub.f64 fd231, fd229, fd230;
sub.f64 fd232, fd226, fd231;
add.f64 fd233, fd231, fd226;
mul.f64 fd234, fd199, 0d3FECD4BCA9CB5C71;
sub.f64 fd235, fd171, fd234;
fma.rn.f64 fd236, fd201, 0d3FE3F3A0E28BEDD1, fd235;
mul.f64 fd237, fd203, 0d3FCC7B90E3024582;
sub.f64 fd238, fd236, fd237;
mul.f64 fd239, fd214, 0d3FDBC4C04D71ABC1;
mul.f64 fd240, fd216, 0d3FE904C37505DE4B;
sub.f64 fd241, fd239, fd240;
fma.rn.f64 fd242, fd218, 0d3FEF329C0558E969, fd241;
sub.f64 fd243, fd238, fd242;
add.f64 fd244, fd242, fd238;
fma.rn.f64 fd245, fd204, 0d3FE3F3A0E28BEDD1, fd172;
mul.f64 fd246, fd206, 0d3FCC7B90E3024582;
sub.f64 fd247, fd245, fd246;
mul.f64 fd248, fd208, 0d3FECD4BCA9CB5C71;
sub.f64 fd249, fd247, fd248;
sub.f64 fd250, fd175, fd195;
mul.f64 fd251, fd250, 0d3FE904C37505DE4B;
sub.f64 fd252, fd179, fd191;
fma.rn.f64 fd253, fd252, 0d3FEF329C0558E969, fd251;
sub.f64 fd254, fd183, fd187;
fma.rn.f64 fd255, fd254, 0d3FDBC4C04D71ABC1, fd253;
add.f64 fd256, fd255, fd249;
sub.f64 fd257, fd249, fd255;
mul.f64 fd258, fd204, 0d3FCC7B90E3024582;
sub.f64 fd259, fd172, fd258;
mul.f64 fd260, fd206, 0d3FECD4BCA9CB5C71;
sub.f64 fd261, fd259, fd260;
fma.rn.f64 fd262, fd208, 0d3FE3F3A0E28BEDD1, fd261;
mul.f64 fd263, fd250, 0d3FEF329C0558E969;
mul.f64 fd264, fd252, 0d3FDBC4C04D71ABC1;
sub.f64 fd265, fd263, fd264;
mul.f64 fd266, fd254, 0d3FE904C37505DE4B;
sub.f64 fd267, fd265, fd266;
add.f64 fd268, fd267, fd262;
sub.f64 fd269, fd262, fd267;
mul.f64 fd270, fd204, 0d3FECD4BCA9CB5C71;
sub.f64 fd271, fd172, fd270;
fma.rn.f64 fd272, fd206, 0d3FE3F3A0E28BEDD1, fd271;
mul.f64 fd273, fd208, 0d3FCC7B90E3024582;
sub.f64 fd274, fd272, fd273;
mul.f64 fd275, fd250, 0d3FDBC4C04D71ABC1;
mul.f64 fd276, fd252, 0d3FE904C37505DE4B;
sub.f64 fd277, fd275, fd276;
fma.rn.f64 fd278, fd254, 0d3FEF329C0558E969, fd277;
add.f64 fd279, fd278, fd274;
sub.f64 fd280, fd274, fd278;
mul.wide.u32 rd7, r7, 613566757;
shr.u64 rd8, rd7, 32;
cvt.u32.u64 r11, rd8;
sub.s32 r12, r7, r11;
shr.u32 r13, r12, 1;
add.s32 r14, r13, r11;
shr.u32 r15, r14, 2;
mul.lo.s32 r16, r15, 7;
sub.s32 r17, r7, r16;
mul.wide.u32 rd9, r15, 16;
mov.u64 rd10, %16;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd281, fd282}, [rd11];
mul.f64 fd285, fd256, fd282;
mul.f64 fd286, fd220, fd282;
mul.f64 fd287, fd281, fd256;
mul.f64 fd288, fd281, fd281;
mul.f64 fd289, fd282, fd282;
sub.f64 fd290, fd288, fd289;
mul.f64 fd291, fd282, fd281;
fma.rn.f64 fd292, fd282, fd281, fd291;
mul.f64 fd293, fd268, fd292;
mul.f64 fd294, fd232, fd292;
mul.f64 fd295, fd290, fd268;
mul.f64 fd296, fd281, fd290;
mul.f64 fd297, fd282, fd292;
sub.f64 fd298, fd296, fd297;
mul.f64 fd299, fd281, fd292;
fma.rn.f64 fd300, fd282, fd290, fd299;
mul.f64 fd301, fd279, fd300;
mul.f64 fd302, fd243, fd300;
mul.f64 fd303, fd298, fd279;
ld.global.v2.f64 {fd304, fd305}, [rd11+784];
mul.f64 fd308, fd280, fd305;
mul.f64 fd309, fd244, fd305;
mul.f64 fd310, fd304, fd280;
mul.f64 fd311, fd281, fd304;
mul.f64 fd312, fd282, fd305;
sub.f64 fd313, fd311, fd312;
mul.f64 fd314, fd281, fd305;
fma.rn.f64 fd315, fd282, fd304, fd314;
mul.f64 fd316, fd269, fd315;
mul.f64 fd317, fd233, fd315;
mul.f64 fd318, fd313, fd269;
mul.f64 fd319, fd281, fd313;
mul.f64 fd320, fd282, fd315;
sub.f64 fd321, fd319, fd320;
mul.f64 fd322, fd281, fd315;
fma.rn.f64 fd323, fd282, fd313, fd322;
mul.f64 fd324, fd257, fd323;
mul.f64 fd325, fd221, fd323;
mul.f64 fd326, fd321, fd257;
shl.b32 r18, r17, 4;
add.s32 r19, r8, r18;
barrier.sync 0;
mad.lo.s32 r20, r15, 784, r19;
add.f64 fd327, fd208, fd207;
add.f64 fd328, fd203, fd202;
st.shared.v2.f64 [r20], {fd328, fd327};
fma.rn.f64 fd329, fd281, fd220, fd285;
sub.f64 fd330, fd287, fd286;
st.shared.v2.f64 [r20+112], {fd329, fd330};
fma.rn.f64 fd331, fd290, fd232, fd293;
sub.f64 fd332, fd295, fd294;
st.shared.v2.f64 [r20+224], {fd331, fd332};
fma.rn.f64 fd333, fd298, fd243, fd301;
sub.f64 fd334, fd303, fd302;
st.shared.v2.f64 [r20+336], {fd333, fd334};
fma.rn.f64 fd335, fd304, fd244, fd308;
sub.f64 fd336, fd310, fd309;
st.shared.v2.f64 [r20+448], {fd335, fd336};
fma.rn.f64 fd337, fd313, fd233, fd316;
sub.f64 fd338, fd318, fd317;
st.shared.v2.f64 [r20+560], {fd337, fd338};
fma.rn.f64 fd339, fd321, fd221, fd324;
sub.f64 fd340, fd326, fd325;
st.shared.v2.f64 [r20+672], {fd339, fd340};
barrier.sync 0;
ld.shared.v2.f64 {fd341, fd342}, [r10];
ld.shared.v2.f64 {fd345, fd346}, [r10+5488];
ld.shared.v2.f64 {fd349, fd350}, [r10+10976];
ld.shared.v2.f64 {fd353, fd354}, [r10+16464];
ld.shared.v2.f64 {fd357, fd358}, [r10+21952];
ld.shared.v2.f64 {fd361, fd362}, [r10+27440];
ld.shared.v2.f64 {fd365, fd366}, [r10+32928];
add.f64 fd369, fd345, fd365;
add.f64 fd370, fd341, fd369;
add.f64 fd371, fd349, fd361;
add.f64 fd372, fd371, fd370;
add.f64 fd373, fd353, fd357;
add.f64 fd374, fd346, fd366;
add.f64 fd375, fd342, fd374;
add.f64 fd376, fd350, fd362;
add.f64 fd377, fd376, fd375;
add.f64 fd378, fd354, fd358;
fma.rn.f64 fd379, fd369, 0d3FE3F3A0E28BEDD1, fd341;
mul.f64 fd380, fd371, 0d3FCC7B90E3024582;
sub.f64 fd381, fd379, fd380;
mul.f64 fd382, fd373, 0d3FECD4BCA9CB5C71;
sub.f64 fd383, fd381, fd382;
sub.f64 fd384, fd346, fd366;
mul.f64 fd385, fd384, 0d3FE904C37505DE4B;
sub.f64 fd386, fd350, fd362;
fma.rn.f64 fd387, fd386, 0d3FEF329C0558E969, fd385;
sub.f64 fd388, fd354, fd358;
fma.rn.f64 fd389, fd388, 0d3FDBC4C04D71ABC1, fd387;
sub.f64 fd390, fd383, fd389;
add.f64 fd391, fd389, fd383;
mul.f64 fd392, fd369, 0d3FCC7B90E3024582;
sub.f64 fd393, fd341, fd392;
mul.f64 fd394, fd371, 0d3FECD4BCA9CB5C71;
sub.f64 fd395, fd393, fd394;
fma.rn.f64 fd396, fd373, 0d3FE3F3A0E28BEDD1, fd395;
mul.f64 fd397, fd384, 0d3FEF329C0558E969;
mul.f64 fd398, fd386, 0d3FDBC4C04D71ABC1;
sub.f64 fd399, fd397, fd398;
mul.f64 fd400, fd388, 0d3FE904C37505DE4B;
sub.f64 fd401, fd399, fd400;
sub.f64 fd402, fd396, fd401;
add.f64 fd403, fd401, fd396;
mul.f64 fd404, fd369, 0d3FECD4BCA9CB5C71;
sub.f64 fd405, fd341, fd404;
fma.rn.f64 fd406, fd371, 0d3FE3F3A0E28BEDD1, fd405;
mul.f64 fd407, fd373, 0d3FCC7B90E3024582;
sub.f64 fd408, fd406, fd407;
mul.f64 fd409, fd384, 0d3FDBC4C04D71ABC1;
mul.f64 fd410, fd386, 0d3FE904C37505DE4B;
sub.f64 fd411, fd409, fd410;
fma.rn.f64 fd412, fd388, 0d3FEF329C0558E969, fd411;
sub.f64 fd413, fd408, fd412;
add.f64 fd414, fd412, fd408;
fma.rn.f64 fd415, fd374, 0d3FE3F3A0E28BEDD1, fd342;
mul.f64 fd416, fd376, 0d3FCC7B90E3024582;
sub.f64 fd417, fd415, fd416;
mul.f64 fd418, fd378, 0d3FECD4BCA9CB5C71;
sub.f64 fd419, fd417, fd418;
sub.f64 fd420, fd345, fd365;
mul.f64 fd421, fd420, 0d3FE904C37505DE4B;
sub.f64 fd422, fd349, fd361;
fma.rn.f64 fd423, fd422, 0d3FEF329C0558E969, fd421;
sub.f64 fd424, fd353, fd357;
fma.rn.f64 fd425, fd424, 0d3FDBC4C04D71ABC1, fd423;
add.f64 fd426, fd425, fd419;
sub.f64 fd427, fd419, fd425;
mul.f64 fd428, fd374, 0d3FCC7B90E3024582;
sub.f64 fd429, fd342, fd428;
mul.f64 fd430, fd376, 0d3FECD4BCA9CB5C71;
sub.f64 fd431, fd429, fd430;
fma.rn.f64 fd432, fd378, 0d3FE3F3A0E28BEDD1, fd431;
mul.f64 fd433, fd420, 0d3FEF329C0558E969;
mul.f64 fd434, fd422, 0d3FDBC4C04D71ABC1;
sub.f64 fd435, fd433, fd434;
mul.f64 fd436, fd424, 0d3FE904C37505DE4B;
sub.f64 fd437, fd435, fd436;
add.f64 fd438, fd437, fd432;
sub.f64 fd439, fd432, fd437;
mul.f64 fd440, fd374, 0d3FECD4BCA9CB5C71;
sub.f64 fd441, fd342, fd440;
fma.rn.f64 fd442, fd376, 0d3FE3F3A0E28BEDD1, fd441;
mul.f64 fd443, fd378, 0d3FCC7B90E3024582;
sub.f64 fd444, fd442, fd443;
mul.f64 fd445, fd420, 0d3FDBC4C04D71ABC1;
mul.f64 fd446, fd422, 0d3FE904C37505DE4B;
sub.f64 fd447, fd445, fd446;
fma.rn.f64 fd448, fd424, 0d3FEF329C0558E969, fd447;
add.f64 fd449, fd448, fd444;
sub.f64 fd450, fd444, fd448;
mul.wide.u32 rd12, r7, 1402438301;
shr.u64 rd13, rd12, 36;
cvt.u32.u64 r21, rd13;
mul.lo.s32 r22, r21, 49;
sub.s32 r23, r7, r22;
mul.wide.u32 rd14, r21, 16;
mov.u64 rd15, %17;
add.s64 rd16, rd15, rd14;
ld.global.v2.f64 {fd451, fd452}, [rd16];
mul.f64 fd455, fd426, fd452;
mul.f64 fd456, fd390, fd452;
mul.f64 fd457, fd451, fd426;
mul.f64 fd458, fd451, fd451;
mul.f64 fd459, fd452, fd452;
sub.f64 fd460, fd458, fd459;
mul.f64 fd461, fd452, fd451;
fma.rn.f64 fd462, fd452, fd451, fd461;
mul.f64 fd463, fd438, fd462;
mul.f64 fd464, fd402, fd462;
mul.f64 fd465, fd460, fd438;
mul.f64 fd466, fd451, fd460;
mul.f64 fd467, fd452, fd462;
sub.f64 fd468, fd466, fd467;
mul.f64 fd469, fd451, fd462;
fma.rn.f64 fd470, fd452, fd460, fd469;
mul.f64 fd471, fd449, fd470;
mul.f64 fd472, fd413, fd470;
mul.f64 fd473, fd468, fd449;
ld.global.v2.f64 {fd474, fd475}, [rd16+112];
mul.f64 fd478, fd450, fd475;
mul.f64 fd479, fd414, fd475;
mul.f64 fd480, fd474, fd450;
mul.f64 fd481, fd451, fd474;
mul.f64 fd482, fd452, fd475;
sub.f64 fd483, fd481, fd482;
mul.f64 fd484, fd451, fd475;
fma.rn.f64 fd485, fd452, fd474, fd484;
mul.f64 fd486, fd439, fd485;
mul.f64 fd487, fd403, fd485;
mul.f64 fd488, fd483, fd439;
mul.f64 fd489, fd451, fd483;
mul.f64 fd490, fd452, fd485;
sub.f64 fd491, fd489, fd490;
mul.f64 fd492, fd451, fd485;
fma.rn.f64 fd493, fd452, fd483, fd492;
mul.f64 fd494, fd427, fd493;
mul.f64 fd495, fd391, fd493;
mul.f64 fd496, fd491, fd427;
shl.b32 r24, r23, 4;
add.s32 r25, r8, r24;
barrier.sync 0;
mad.lo.s32 r26, r21, 5488, r25;
add.f64 fd497, fd378, fd377;
add.f64 fd498, fd373, fd372;
st.shared.v2.f64 [r26], {fd498, fd497};
fma.rn.f64 fd499, fd451, fd390, fd455;
sub.f64 fd500, fd457, fd456;
st.shared.v2.f64 [r26+784], {fd499, fd500};
fma.rn.f64 fd501, fd460, fd402, fd463;
sub.f64 fd502, fd465, fd464;
st.shared.v2.f64 [r26+1568], {fd501, fd502};
fma.rn.f64 fd503, fd468, fd413, fd471;
sub.f64 fd504, fd473, fd472;
st.shared.v2.f64 [r26+2352], {fd503, fd504};
fma.rn.f64 fd505, fd474, fd414, fd478;
sub.f64 fd506, fd480, fd479;
st.shared.v2.f64 [r26+3136], {fd505, fd506};
fma.rn.f64 fd507, fd483, fd403, fd486;
sub.f64 fd508, fd488, fd487;
st.shared.v2.f64 [r26+3920], {fd507, fd508};
fma.rn.f64 fd509, fd491, fd391, fd494;
sub.f64 fd510, fd496, fd495;
st.shared.v2.f64 [r26+4704], {fd509, fd510};
barrier.sync 0;
ld.shared.v2.f64 {fd511, fd512}, [r10];
ld.shared.v2.f64 {fd515, fd516}, [r10+5488];
ld.shared.v2.f64 {fd519, fd520}, [r10+10976];
ld.shared.v2.f64 {fd523, fd524}, [r10+16464];
ld.shared.v2.f64 {fd527, fd528}, [r10+21952];
ld.shared.v2.f64 {fd531, fd532}, [r10+27440];
ld.shared.v2.f64 {fd535, fd536}, [r10+32928];
add.f64 fd539, fd515, fd535;
add.f64 fd540, fd511, fd539;
add.f64 fd541, fd519, fd531;
add.f64 fd542, fd541, fd540;
add.f64 fd543, fd523, fd527;
add.f64 fd544, fd516, fd536;
add.f64 fd545, fd512, fd544;
add.f64 fd546, fd520, fd532;
add.f64 fd547, fd546, fd545;
add.f64 fd548, fd524, fd528;
fma.rn.f64 fd549, fd539, 0d3FE3F3A0E28BEDD1, fd511;
mul.f64 fd550, fd541, 0d3FCC7B90E3024582;
sub.f64 fd551, fd549, fd550;
mul.f64 fd552, fd543, 0d3FECD4BCA9CB5C71;
sub.f64 fd553, fd551, fd552;
sub.f64 fd554, fd516, fd536;
mul.f64 fd555, fd554, 0d3FE904C37505DE4B;
sub.f64 fd556, fd520, fd532;
fma.rn.f64 fd557, fd556, 0d3FEF329C0558E969, fd555;
sub.f64 fd558, fd524, fd528;
fma.rn.f64 fd559, fd558, 0d3FDBC4C04D71ABC1, fd557;
mul.f64 fd560, fd539, 0d3FCC7B90E3024582;
sub.f64 fd561, fd511, fd560;
mul.f64 fd562, fd541, 0d3FECD4BCA9CB5C71;
sub.f64 fd563, fd561, fd562;
fma.rn.f64 fd564, fd543, 0d3FE3F3A0E28BEDD1, fd563;
mul.f64 fd565, fd554, 0d3FEF329C0558E969;
mul.f64 fd566, fd556, 0d3FDBC4C04D71ABC1;
sub.f64 fd567, fd565, fd566;
mul.f64 fd568, fd558, 0d3FE904C37505DE4B;
sub.f64 fd569, fd567, fd568;
mul.f64 fd570, fd539, 0d3FECD4BCA9CB5C71;
sub.f64 fd571, fd511, fd570;
fma.rn.f64 fd572, fd541, 0d3FE3F3A0E28BEDD1, fd571;
mul.f64 fd573, fd543, 0d3FCC7B90E3024582;
sub.f64 fd574, fd572, fd573;
mul.f64 fd575, fd554, 0d3FDBC4C04D71ABC1;
mul.f64 fd576, fd556, 0d3FE904C37505DE4B;
sub.f64 fd577, fd575, fd576;
fma.rn.f64 fd578, fd558, 0d3FEF329C0558E969, fd577;
fma.rn.f64 fd579, fd544, 0d3FE3F3A0E28BEDD1, fd512;
mul.f64 fd580, fd546, 0d3FCC7B90E3024582;
sub.f64 fd581, fd579, fd580;
mul.f64 fd582, fd548, 0d3FECD4BCA9CB5C71;
sub.f64 fd583, fd581, fd582;
sub.f64 fd584, fd515, fd535;
mul.f64 fd585, fd584, 0d3FE904C37505DE4B;
sub.f64 fd586, fd519, fd531;
fma.rn.f64 fd587, fd586, 0d3FEF329C0558E969, fd585;
sub.f64 fd588, fd523, fd527;
fma.rn.f64 fd589, fd588, 0d3FDBC4C04D71ABC1, fd587;
mul.f64 fd590, fd544, 0d3FCC7B90E3024582;
sub.f64 fd591, fd512, fd590;
mul.f64 fd592, fd546, 0d3FECD4BCA9CB5C71;
sub.f64 fd593, fd591, fd592;
fma.rn.f64 fd594, fd548, 0d3FE3F3A0E28BEDD1, fd593;
mul.f64 fd595, fd584, 0d3FEF329C0558E969;
mul.f64 fd596, fd586, 0d3FDBC4C04D71ABC1;
sub.f64 fd597, fd595, fd596;
mul.f64 fd598, fd588, 0d3FE904C37505DE4B;
sub.f64 fd599, fd597, fd598;
mul.f64 fd600, fd544, 0d3FECD4BCA9CB5C71;
sub.f64 fd601, fd512, fd600;
fma.rn.f64 fd602, fd546, 0d3FE3F3A0E28BEDD1, fd601;
mul.f64 fd603, fd548, 0d3FCC7B90E3024582;
sub.f64 fd604, fd602, fd603;
mul.f64 fd605, fd584, 0d3FDBC4C04D71ABC1;
mul.f64 fd606, fd586, 0d3FE904C37505DE4B;
sub.f64 fd607, fd605, fd606;
fma.rn.f64 fd608, fd588, 0d3FEF329C0558E969, fd607;
add.f64 %1, fd548, fd547;
add.f64 %0, fd543, fd542;
add.f64 %3, fd589, fd583;
sub.f64 %2, fd553, fd559;
add.f64 %5, fd599, fd594;
sub.f64 %4, fd564, fd569;
add.f64 %7, fd608, fd604;
sub.f64 %6, fd574, fd578;
sub.f64 %9, fd604, fd608;
add.f64 %8, fd578, fd574;
sub.f64 %11, fd594, fd599;
add.f64 %10, fd569, fd564;
sub.f64 %13, fd583, fd589;
add.f64 %12, fd559, fd553;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y): "r"(smem), "l"(lut_dp_7_2401), "l"(lut_dp_7_343), "l"(lut_dp_7_49), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y));
};




template<> __forceinline__ __device__ void cufftdx_private_function<723, double, 1>(cufftdx::detail::complex<double> *rmem, unsigned smem){

asm volatile (R"({
.reg .b32 r<27>;
.reg .f64 fd<581>;
.reg .b64 rd<17>;
mov.u32 r1, %tid.y;
mov.u32 r2, %14;
mad.lo.s32 r3, r1, 19208, r2;
mov.u32 r4, %tid.x;
add.f64 fd29, %20, %34;
add.f64 fd30, %18, fd29;
add.f64 fd31, %23, %31;
add.f64 fd32, fd31, fd30;
add.f64 fd33, %26, %28;
add.f64 fd34, fd33, fd32;
add.f64 fd35, %22, %35;
add.f64 fd36, %19, fd35;
add.f64 fd37, %25, %33;
add.f64 fd38, fd37, fd36;
add.f64 fd39, %27, %30;
add.f64 fd40, fd39, fd38;
fma.rn.f64 fd41, fd29, 0d3FE3F3A0E28BEDD1, %18;
mul.f64 fd42, fd31, 0d3FCC7B90E3024582;
sub.f64 fd43, fd41, fd42;
mul.f64 fd44, fd33, 0d3FECD4BCA9CB5C71;
sub.f64 fd45, fd43, fd44;
sub.f64 fd46, %22, %35;
mul.f64 fd47, fd46, 0d3FE904C37505DE4B;
sub.f64 fd48, %25, %33;
fma.rn.f64 fd49, fd48, 0d3FEF329C0558E969, fd47;
sub.f64 fd50, %27, %30;
fma.rn.f64 fd51, fd50, 0d3FDBC4C04D71ABC1, fd49;
sub.f64 fd52, fd45, fd51;
add.f64 fd53, fd51, fd45;
mul.f64 fd54, fd29, 0d3FCC7B90E3024582;
sub.f64 fd55, %18, fd54;
mul.f64 fd56, fd31, 0d3FECD4BCA9CB5C71;
sub.f64 fd57, fd55, fd56;
fma.rn.f64 fd58, fd33, 0d3FE3F3A0E28BEDD1, fd57;
mul.f64 fd59, fd46, 0d3FEF329C0558E969;
mul.f64 fd60, fd48, 0d3FDBC4C04D71ABC1;
sub.f64 fd61, fd59, fd60;
mul.f64 fd62, fd50, 0d3FE904C37505DE4B;
sub.f64 fd63, fd61, fd62;
sub.f64 fd64, fd58, fd63;
add.f64 fd65, fd63, fd58;
mul.f64 fd66, fd29, 0d3FECD4BCA9CB5C71;
sub.f64 fd67, %18, fd66;
fma.rn.f64 fd68, fd31, 0d3FE3F3A0E28BEDD1, fd67;
mul.f64 fd69, fd33, 0d3FCC7B90E3024582;
sub.f64 fd70, fd68, fd69;
mul.f64 fd71, fd46, 0d3FDBC4C04D71ABC1;
mul.f64 fd72, fd48, 0d3FE904C37505DE4B;
sub.f64 fd73, fd71, fd72;
fma.rn.f64 fd74, fd50, 0d3FEF329C0558E969, fd73;
sub.f64 fd75, fd70, fd74;
add.f64 fd76, fd74, fd70;
fma.rn.f64 fd77, fd35, 0d3FE3F3A0E28BEDD1, %19;
mul.f64 fd78, fd37, 0d3FCC7B90E3024582;
sub.f64 fd79, fd77, fd78;
mul.f64 fd80, fd39, 0d3FECD4BCA9CB5C71;
sub.f64 fd81, fd79, fd80;
sub.f64 fd82, %20, %34;
mul.f64 fd83, fd82, 0d3FE904C37505DE4B;
sub.f64 fd84, %23, %31;
fma.rn.f64 fd85, fd84, 0d3FEF329C0558E969, fd83;
sub.f64 fd86, %26, %28;
fma.rn.f64 fd87, fd86, 0d3FDBC4C04D71ABC1, fd85;
add.f64 fd88, fd87, fd81;
sub.f64 fd89, fd81, fd87;
mul.f64 fd90, fd35, 0d3FCC7B90E3024582;
sub.f64 fd91, %19, fd90;
mul.f64 fd92, fd37, 0d3FECD4BCA9CB5C71;
sub.f64 fd93, fd91, fd92;
fma.rn.f64 fd94, fd39, 0d3FE3F3A0E28BEDD1, fd93;
mul.f64 fd95, fd82, 0d3FEF329C0558E969;
mul.f64 fd96, fd84, 0d3FDBC4C04D71ABC1;
sub.f64 fd97, fd95, fd96;
mul.f64 fd98, fd86, 0d3FE904C37505DE4B;
sub.f64 fd99, fd97, fd98;
add.f64 fd100, fd99, fd94;
sub.f64 fd101, fd94, fd99;
mul.f64 fd102, fd35, 0d3FECD4BCA9CB5C71;
sub.f64 fd103, %19, fd102;
fma.rn.f64 fd104, fd37, 0d3FE3F3A0E28BEDD1, fd103;
mul.f64 fd105, fd39, 0d3FCC7B90E3024582;
sub.f64 fd106, fd104, fd105;
mul.f64 fd107, fd82, 0d3FDBC4C04D71ABC1;
mul.f64 fd108, fd84, 0d3FE904C37505DE4B;
sub.f64 fd109, fd107, fd108;
fma.rn.f64 fd110, fd86, 0d3FEF329C0558E969, fd109;
add.f64 fd111, fd110, fd106;
sub.f64 fd112, fd106, fd110;
mul.wide.u32 rd2, r4, -1089394037;
shr.u64 rd3, rd2, 40;
cvt.u32.u64 r5, rd3;
mul.lo.s32 r6, r5, 343;
sub.s32 r7, r4, r6;
mul.wide.u32 rd4, r7, 16;
mov.u64 rd5, %15;
add.s64 rd6, rd5, rd4;
ld.global.v2.f64 {fd113, fd114}, [rd6];
mul.f64 fd117, fd88, fd114;
fma.rn.f64 fd118, fd113, fd52, fd117;
mul.f64 fd119, fd52, fd114;
mul.f64 fd120, fd113, fd88;
sub.f64 fd121, fd120, fd119;
mul.f64 fd122, fd113, fd113;
mul.f64 fd123, fd114, fd114;
sub.f64 fd124, fd122, fd123;
mul.f64 fd125, fd114, fd113;
fma.rn.f64 fd126, fd114, fd113, fd125;
mul.f64 fd127, fd100, fd126;
fma.rn.f64 fd128, fd124, fd64, fd127;
mul.f64 fd129, fd64, fd126;
mul.f64 fd130, fd124, fd100;
sub.f64 fd131, fd130, fd129;
mul.f64 fd132, fd113, fd124;
mul.f64 fd133, fd114, fd126;
sub.f64 fd134, fd132, fd133;
mul.f64 fd135, fd113, fd126;
fma.rn.f64 fd136, fd114, fd124, fd135;
mul.f64 fd137, fd111, fd136;
fma.rn.f64 fd138, fd134, fd75, fd137;
mul.f64 fd139, fd75, fd136;
mul.f64 fd140, fd134, fd111;
sub.f64 fd141, fd140, fd139;
ld.global.v2.f64 {fd142, fd143}, [rd6+5488];
mul.f64 fd146, fd112, fd143;
fma.rn.f64 fd147, fd142, fd76, fd146;
mul.f64 fd148, fd76, fd143;
mul.f64 fd149, fd142, fd112;
sub.f64 fd150, fd149, fd148;
mul.f64 fd151, fd113, fd142;
mul.f64 fd152, fd114, fd143;
sub.f64 fd153, fd151, fd152;
mul.f64 fd154, fd113, fd143;
fma.rn.f64 fd155, fd114, fd142, fd154;
mul.f64 fd156, fd101, fd155;
fma.rn.f64 fd157, fd153, fd65, fd156;
mul.f64 fd158, fd65, fd155;
mul.f64 fd159, fd153, fd101;
sub.f64 fd160, fd159, fd158;
mul.f64 fd161, fd113, fd153;
mul.f64 fd162, fd114, fd155;
sub.f64 fd163, fd161, fd162;
mul.f64 fd164, fd113, fd155;
fma.rn.f64 fd165, fd114, fd153, fd164;
mul.f64 fd166, fd89, fd165;
fma.rn.f64 fd167, fd163, fd53, fd166;
mul.f64 fd168, fd53, fd165;
mul.f64 fd169, fd163, fd89;
sub.f64 fd170, fd169, fd168;
mad.lo.s32 r8, r5, 19208, r3;
barrier.sync 0;
mad.lo.s32 r9, r7, 56, r8;
st.shared.f64 [r9], fd34;
st.shared.f64 [r9+8], fd118;
st.shared.f64 [r9+16], fd128;
st.shared.f64 [r9+24], fd138;
st.shared.f64 [r9+32], fd147;
st.shared.f64 [r9+40], fd157;
st.shared.f64 [r9+48], fd167;
barrier.sync 0;
mad.lo.s32 r10, r7, -48, r9;
ld.shared.f64 fd171, [r10];
ld.shared.f64 fd172, [r10+2744];
ld.shared.f64 fd173, [r10+5488];
ld.shared.f64 fd174, [r10+8232];
ld.shared.f64 fd175, [r10+10976];
ld.shared.f64 fd176, [r10+13720];
ld.shared.f64 fd177, [r10+16464];
barrier.sync 0;
st.shared.f64 [r9], fd40;
st.shared.f64 [r9+8], fd121;
st.shared.f64 [r9+16], fd131;
st.shared.f64 [r9+24], fd141;
st.shared.f64 [r9+32], fd150;
st.shared.f64 [r9+40], fd160;
st.shared.f64 [r9+48], fd170;
barrier.sync 0;
ld.shared.f64 fd178, [r10];
ld.shared.f64 fd179, [r10+2744];
ld.shared.f64 fd180, [r10+5488];
ld.shared.f64 fd181, [r10+8232];
ld.shared.f64 fd182, [r10+10976];
ld.shared.f64 fd183, [r10+13720];
ld.shared.f64 fd184, [r10+16464];
add.f64 fd185, fd172, fd177;
add.f64 fd186, fd171, fd185;
add.f64 fd187, fd173, fd176;
add.f64 fd188, fd187, fd186;
add.f64 fd189, fd174, fd175;
add.f64 fd190, fd189, fd188;
add.f64 fd191, fd179, fd184;
add.f64 fd192, fd178, fd191;
add.f64 fd193, fd180, fd183;
add.f64 fd194, fd193, fd192;
add.f64 fd195, fd181, fd182;
add.f64 fd196, fd195, fd194;
fma.rn.f64 fd197, fd185, 0d3FE3F3A0E28BEDD1, fd171;
mul.f64 fd198, fd187, 0d3FCC7B90E3024582;
sub.f64 fd199, fd197, fd198;
mul.f64 fd200, fd189, 0d3FECD4BCA9CB5C71;
sub.f64 fd201, fd199, fd200;
sub.f64 fd202, fd179, fd184;
mul.f64 fd203, fd202, 0d3FE904C37505DE4B;
sub.f64 fd204, fd180, fd183;
fma.rn.f64 fd205, fd204, 0d3FEF329C0558E969, fd203;
sub.f64 fd206, fd181, fd182;
fma.rn.f64 fd207, fd206, 0d3FDBC4C04D71ABC1, fd205;
sub.f64 fd208, fd201, fd207;
add.f64 fd209, fd207, fd201;
mul.f64 fd210, fd185, 0d3FCC7B90E3024582;
sub.f64 fd211, fd171, fd210;
mul.f64 fd212, fd187, 0d3FECD4BCA9CB5C71;
sub.f64 fd213, fd211, fd212;
fma.rn.f64 fd214, fd189, 0d3FE3F3A0E28BEDD1, fd213;
mul.f64 fd215, fd202, 0d3FEF329C0558E969;
mul.f64 fd216, fd204, 0d3FDBC4C04D71ABC1;
sub.f64 fd217, fd215, fd216;
mul.f64 fd218, fd206, 0d3FE904C37505DE4B;
sub.f64 fd219, fd217, fd218;
sub.f64 fd220, fd214, fd219;
add.f64 fd221, fd219, fd214;
mul.f64 fd222, fd185, 0d3FECD4BCA9CB5C71;
sub.f64 fd223, fd171, fd222;
fma.rn.f64 fd224, fd187, 0d3FE3F3A0E28BEDD1, fd223;
mul.f64 fd225, fd189, 0d3FCC7B90E3024582;
sub.f64 fd226, fd224, fd225;
mul.f64 fd227, fd202, 0d3FDBC4C04D71ABC1;
mul.f64 fd228, fd204, 0d3FE904C37505DE4B;
sub.f64 fd229, fd227, fd228;
fma.rn.f64 fd230, fd206, 0d3FEF329C0558E969, fd229;
sub.f64 fd231, fd226, fd230;
add.f64 fd232, fd230, fd226;
fma.rn.f64 fd233, fd191, 0d3FE3F3A0E28BEDD1, fd178;
mul.f64 fd234, fd193, 0d3FCC7B90E3024582;
sub.f64 fd235, fd233, fd234;
mul.f64 fd236, fd195, 0d3FECD4BCA9CB5C71;
sub.f64 fd237, fd235, fd236;
sub.f64 fd238, fd172, fd177;
mul.f64 fd239, fd238, 0d3FE904C37505DE4B;
sub.f64 fd240, fd173, fd176;
fma.rn.f64 fd241, fd240, 0d3FEF329C0558E969, fd239;
sub.f64 fd242, fd174, fd175;
fma.rn.f64 fd243, fd242, 0d3FDBC4C04D71ABC1, fd241;
add.f64 fd244, fd243, fd237;
sub.f64 fd245, fd237, fd243;
mul.f64 fd246, fd191, 0d3FCC7B90E3024582;
sub.f64 fd247, fd178, fd246;
mul.f64 fd248, fd193, 0d3FECD4BCA9CB5C71;
sub.f64 fd249, fd247, fd248;
fma.rn.f64 fd250, fd195, 0d3FE3F3A0E28BEDD1, fd249;
mul.f64 fd251, fd238, 0d3FEF329C0558E969;
mul.f64 fd252, fd240, 0d3FDBC4C04D71ABC1;
sub.f64 fd253, fd251, fd252;
mul.f64 fd254, fd242, 0d3FE904C37505DE4B;
sub.f64 fd255, fd253, fd254;
add.f64 fd256, fd255, fd250;
sub.f64 fd257, fd250, fd255;
mul.f64 fd258, fd191, 0d3FECD4BCA9CB5C71;
sub.f64 fd259, fd178, fd258;
fma.rn.f64 fd260, fd193, 0d3FE3F3A0E28BEDD1, fd259;
mul.f64 fd261, fd195, 0d3FCC7B90E3024582;
sub.f64 fd262, fd260, fd261;
mul.f64 fd263, fd238, 0d3FDBC4C04D71ABC1;
mul.f64 fd264, fd240, 0d3FE904C37505DE4B;
sub.f64 fd265, fd263, fd264;
fma.rn.f64 fd266, fd242, 0d3FEF329C0558E969, fd265;
add.f64 fd267, fd266, fd262;
sub.f64 fd268, fd262, fd266;
mul.wide.u32 rd7, r7, 613566757;
shr.u64 rd8, rd7, 32;
cvt.u32.u64 r11, rd8;
sub.s32 r12, r7, r11;
shr.u32 r13, r12, 1;
add.s32 r14, r13, r11;
shr.u32 r15, r14, 2;
mul.lo.s32 r16, r15, 7;
sub.s32 r17, r7, r16;
mul.wide.u32 rd9, r15, 16;
mov.u64 rd10, %16;
add.s64 rd11, rd10, rd9;
ld.global.v2.f64 {fd269, fd270}, [rd11];
mul.f64 fd273, fd244, fd270;
fma.rn.f64 fd274, fd269, fd208, fd273;
mul.f64 fd275, fd208, fd270;
mul.f64 fd276, fd269, fd244;
sub.f64 fd277, fd276, fd275;
mul.f64 fd278, fd269, fd269;
mul.f64 fd279, fd270, fd270;
sub.f64 fd280, fd278, fd279;
mul.f64 fd281, fd270, fd269;
fma.rn.f64 fd282, fd270, fd269, fd281;
mul.f64 fd283, fd256, fd282;
fma.rn.f64 fd284, fd280, fd220, fd283;
mul.f64 fd285, fd220, fd282;
mul.f64 fd286, fd280, fd256;
sub.f64 fd287, fd286, fd285;
mul.f64 fd288, fd269, fd280;
mul.f64 fd289, fd270, fd282;
sub.f64 fd290, fd288, fd289;
mul.f64 fd291, fd269, fd282;
fma.rn.f64 fd292, fd270, fd280, fd291;
mul.f64 fd293, fd267, fd292;
fma.rn.f64 fd294, fd290, fd231, fd293;
mul.f64 fd295, fd231, fd292;
mul.f64 fd296, fd290, fd267;
sub.f64 fd297, fd296, fd295;
ld.global.v2.f64 {fd298, fd299}, [rd11+784];
mul.f64 fd302, fd268, fd299;
fma.rn.f64 fd303, fd298, fd232, fd302;
mul.f64 fd304, fd232, fd299;
mul.f64 fd305, fd298, fd268;
sub.f64 fd306, fd305, fd304;
mul.f64 fd307, fd269, fd298;
mul.f64 fd308, fd270, fd299;
sub.f64 fd309, fd307, fd308;
mul.f64 fd310, fd269, fd299;
fma.rn.f64 fd311, fd270, fd298, fd310;
mul.f64 fd312, fd257, fd311;
fma.rn.f64 fd313, fd309, fd221, fd312;
mul.f64 fd314, fd221, fd311;
mul.f64 fd315, fd309, fd257;
sub.f64 fd316, fd315, fd314;
mul.f64 fd317, fd269, fd309;
mul.f64 fd318, fd270, fd311;
sub.f64 fd319, fd317, fd318;
mul.f64 fd320, fd269, fd311;
fma.rn.f64 fd321, fd270, fd309, fd320;
mul.f64 fd322, fd245, fd321;
fma.rn.f64 fd323, fd319, fd209, fd322;
mul.f64 fd324, fd209, fd321;
mul.f64 fd325, fd319, fd245;
sub.f64 fd326, fd325, fd324;
shl.b32 r18, r17, 3;
add.s32 r19, r8, r18;
barrier.sync 0;
mad.lo.s32 r20, r15, 392, r19;
st.shared.f64 [r20], fd190;
st.shared.f64 [r20+56], fd274;
st.shared.f64 [r20+112], fd284;
st.shared.f64 [r20+168], fd294;
st.shared.f64 [r20+224], fd303;
st.shared.f64 [r20+280], fd313;
st.shared.f64 [r20+336], fd323;
barrier.sync 0;
ld.shared.f64 fd327, [r10];
ld.shared.f64 fd328, [r10+2744];
ld.shared.f64 fd329, [r10+5488];
ld.shared.f64 fd330, [r10+8232];
ld.shared.f64 fd331, [r10+10976];
ld.shared.f64 fd332, [r10+13720];
ld.shared.f64 fd333, [r10+16464];
barrier.sync 0;
st.shared.f64 [r20], fd196;
st.shared.f64 [r20+56], fd277;
st.shared.f64 [r20+112], fd287;
st.shared.f64 [r20+168], fd297;
st.shared.f64 [r20+224], fd306;
st.shared.f64 [r20+280], fd316;
st.shared.f64 [r20+336], fd326;
barrier.sync 0;
ld.shared.f64 fd334, [r10];
ld.shared.f64 fd335, [r10+2744];
ld.shared.f64 fd336, [r10+5488];
ld.shared.f64 fd337, [r10+8232];
ld.shared.f64 fd338, [r10+10976];
ld.shared.f64 fd339, [r10+13720];
ld.shared.f64 fd340, [r10+16464];
add.f64 fd341, fd328, fd333;
add.f64 fd342, fd327, fd341;
add.f64 fd343, fd329, fd332;
add.f64 fd344, fd343, fd342;
add.f64 fd345, fd330, fd331;
add.f64 fd346, fd345, fd344;
add.f64 fd347, fd335, fd340;
add.f64 fd348, fd334, fd347;
add.f64 fd349, fd336, fd339;
add.f64 fd350, fd349, fd348;
add.f64 fd351, fd337, fd338;
add.f64 fd352, fd351, fd350;
fma.rn.f64 fd353, fd341, 0d3FE3F3A0E28BEDD1, fd327;
mul.f64 fd354, fd343, 0d3FCC7B90E3024582;
sub.f64 fd355, fd353, fd354;
mul.f64 fd356, fd345, 0d3FECD4BCA9CB5C71;
sub.f64 fd357, fd355, fd356;
sub.f64 fd358, fd335, fd340;
mul.f64 fd359, fd358, 0d3FE904C37505DE4B;
sub.f64 fd360, fd336, fd339;
fma.rn.f64 fd361, fd360, 0d3FEF329C0558E969, fd359;
sub.f64 fd362, fd337, fd338;
fma.rn.f64 fd363, fd362, 0d3FDBC4C04D71ABC1, fd361;
sub.f64 fd364, fd357, fd363;
add.f64 fd365, fd363, fd357;
mul.f64 fd366, fd341, 0d3FCC7B90E3024582;
sub.f64 fd367, fd327, fd366;
mul.f64 fd368, fd343, 0d3FECD4BCA9CB5C71;
sub.f64 fd369, fd367, fd368;
fma.rn.f64 fd370, fd345, 0d3FE3F3A0E28BEDD1, fd369;
mul.f64 fd371, fd358, 0d3FEF329C0558E969;
mul.f64 fd372, fd360, 0d3FDBC4C04D71ABC1;
sub.f64 fd373, fd371, fd372;
mul.f64 fd374, fd362, 0d3FE904C37505DE4B;
sub.f64 fd375, fd373, fd374;
sub.f64 fd376, fd370, fd375;
add.f64 fd377, fd375, fd370;
mul.f64 fd378, fd341, 0d3FECD4BCA9CB5C71;
sub.f64 fd379, fd327, fd378;
fma.rn.f64 fd380, fd343, 0d3FE3F3A0E28BEDD1, fd379;
mul.f64 fd381, fd345, 0d3FCC7B90E3024582;
sub.f64 fd382, fd380, fd381;
mul.f64 fd383, fd358, 0d3FDBC4C04D71ABC1;
mul.f64 fd384, fd360, 0d3FE904C37505DE4B;
sub.f64 fd385, fd383, fd384;
fma.rn.f64 fd386, fd362, 0d3FEF329C0558E969, fd385;
sub.f64 fd387, fd382, fd386;
add.f64 fd388, fd386, fd382;
fma.rn.f64 fd389, fd347, 0d3FE3F3A0E28BEDD1, fd334;
mul.f64 fd390, fd349, 0d3FCC7B90E3024582;
sub.f64 fd391, fd389, fd390;
mul.f64 fd392, fd351, 0d3FECD4BCA9CB5C71;
sub.f64 fd393, fd391, fd392;
sub.f64 fd394, fd328, fd333;
mul.f64 fd395, fd394, 0d3FE904C37505DE4B;
sub.f64 fd396, fd329, fd332;
fma.rn.f64 fd397, fd396, 0d3FEF329C0558E969, fd395;
sub.f64 fd398, fd330, fd331;
fma.rn.f64 fd399, fd398, 0d3FDBC4C04D71ABC1, fd397;
add.f64 fd400, fd399, fd393;
sub.f64 fd401, fd393, fd399;
mul.f64 fd402, fd347, 0d3FCC7B90E3024582;
sub.f64 fd403, fd334, fd402;
mul.f64 fd404, fd349, 0d3FECD4BCA9CB5C71;
sub.f64 fd405, fd403, fd404;
fma.rn.f64 fd406, fd351, 0d3FE3F3A0E28BEDD1, fd405;
mul.f64 fd407, fd394, 0d3FEF329C0558E969;
mul.f64 fd408, fd396, 0d3FDBC4C04D71ABC1;
sub.f64 fd409, fd407, fd408;
mul.f64 fd410, fd398, 0d3FE904C37505DE4B;
sub.f64 fd411, fd409, fd410;
add.f64 fd412, fd411, fd406;
sub.f64 fd413, fd406, fd411;
mul.f64 fd414, fd347, 0d3FECD4BCA9CB5C71;
sub.f64 fd415, fd334, fd414;
fma.rn.f64 fd416, fd349, 0d3FE3F3A0E28BEDD1, fd415;
mul.f64 fd417, fd351, 0d3FCC7B90E3024582;
sub.f64 fd418, fd416, fd417;
mul.f64 fd419, fd394, 0d3FDBC4C04D71ABC1;
mul.f64 fd420, fd396, 0d3FE904C37505DE4B;
sub.f64 fd421, fd419, fd420;
fma.rn.f64 fd422, fd398, 0d3FEF329C0558E969, fd421;
add.f64 fd423, fd422, fd418;
sub.f64 fd424, fd418, fd422;
mul.wide.u32 rd12, r7, 1402438301;
shr.u64 rd13, rd12, 36;
cvt.u32.u64 r21, rd13;
mul.lo.s32 r22, r21, 49;
sub.s32 r23, r7, r22;
mul.wide.u32 rd14, r21, 16;
mov.u64 rd15, %17;
add.s64 rd16, rd15, rd14;
ld.global.v2.f64 {fd425, fd426}, [rd16];
mul.f64 fd429, fd400, fd426;
fma.rn.f64 fd430, fd425, fd364, fd429;
mul.f64 fd431, fd364, fd426;
mul.f64 fd432, fd425, fd400;
sub.f64 fd433, fd432, fd431;
mul.f64 fd434, fd425, fd425;
mul.f64 fd435, fd426, fd426;
sub.f64 fd436, fd434, fd435;
mul.f64 fd437, fd426, fd425;
fma.rn.f64 fd438, fd426, fd425, fd437;
mul.f64 fd439, fd412, fd438;
fma.rn.f64 fd440, fd436, fd376, fd439;
mul.f64 fd441, fd376, fd438;
mul.f64 fd442, fd436, fd412;
sub.f64 fd443, fd442, fd441;
mul.f64 fd444, fd425, fd436;
mul.f64 fd445, fd426, fd438;
sub.f64 fd446, fd444, fd445;
mul.f64 fd447, fd425, fd438;
fma.rn.f64 fd448, fd426, fd436, fd447;
mul.f64 fd449, fd423, fd448;
fma.rn.f64 fd450, fd446, fd387, fd449;
mul.f64 fd451, fd387, fd448;
mul.f64 fd452, fd446, fd423;
sub.f64 fd453, fd452, fd451;
ld.global.v2.f64 {fd454, fd455}, [rd16+112];
mul.f64 fd458, fd424, fd455;
fma.rn.f64 fd459, fd454, fd388, fd458;
mul.f64 fd460, fd388, fd455;
mul.f64 fd461, fd454, fd424;
sub.f64 fd462, fd461, fd460;
mul.f64 fd463, fd425, fd454;
mul.f64 fd464, fd426, fd455;
sub.f64 fd465, fd463, fd464;
mul.f64 fd466, fd425, fd455;
fma.rn.f64 fd467, fd426, fd454, fd466;
mul.f64 fd468, fd413, fd467;
fma.rn.f64 fd469, fd465, fd377, fd468;
mul.f64 fd470, fd377, fd467;
mul.f64 fd471, fd465, fd413;
sub.f64 fd472, fd471, fd470;
mul.f64 fd473, fd425, fd465;
mul.f64 fd474, fd426, fd467;
sub.f64 fd475, fd473, fd474;
mul.f64 fd476, fd425, fd467;
fma.rn.f64 fd477, fd426, fd465, fd476;
mul.f64 fd478, fd401, fd477;
fma.rn.f64 fd479, fd475, fd365, fd478;
mul.f64 fd480, fd365, fd477;
mul.f64 fd481, fd475, fd401;
sub.f64 fd482, fd481, fd480;
shl.b32 r24, r23, 3;
add.s32 r25, r8, r24;
barrier.sync 0;
mad.lo.s32 r26, r21, 2744, r25;
st.shared.f64 [r26], fd346;
st.shared.f64 [r26+392], fd430;
st.shared.f64 [r26+784], fd440;
st.shared.f64 [r26+1176], fd450;
st.shared.f64 [r26+1568], fd459;
st.shared.f64 [r26+1960], fd469;
st.shared.f64 [r26+2352], fd479;
barrier.sync 0;
ld.shared.f64 fd483, [r10];
ld.shared.f64 fd484, [r10+2744];
ld.shared.f64 fd485, [r10+5488];
ld.shared.f64 fd486, [r10+8232];
ld.shared.f64 fd487, [r10+10976];
ld.shared.f64 fd488, [r10+13720];
ld.shared.f64 fd489, [r10+16464];
barrier.sync 0;
st.shared.f64 [r26], fd352;
st.shared.f64 [r26+392], fd433;
st.shared.f64 [r26+784], fd443;
st.shared.f64 [r26+1176], fd453;
st.shared.f64 [r26+1568], fd462;
st.shared.f64 [r26+1960], fd472;
st.shared.f64 [r26+2352], fd482;
barrier.sync 0;
ld.shared.f64 fd490, [r10];
ld.shared.f64 fd491, [r10+2744];
ld.shared.f64 fd492, [r10+5488];
ld.shared.f64 fd493, [r10+8232];
ld.shared.f64 fd494, [r10+10976];
ld.shared.f64 fd495, [r10+13720];
ld.shared.f64 fd496, [r10+16464];
add.f64 fd497, fd484, fd489;
add.f64 fd498, fd483, fd497;
add.f64 fd499, fd485, fd488;
add.f64 fd500, fd499, fd498;
add.f64 fd501, fd486, fd487;
add.f64 fd502, fd491, fd496;
add.f64 fd503, fd490, fd502;
add.f64 fd504, fd492, fd495;
add.f64 fd505, fd504, fd503;
add.f64 fd506, fd493, fd494;
fma.rn.f64 fd507, fd497, 0d3FE3F3A0E28BEDD1, fd483;
mul.f64 fd508, fd499, 0d3FCC7B90E3024582;
sub.f64 fd509, fd507, fd508;
mul.f64 fd510, fd501, 0d3FECD4BCA9CB5C71;
sub.f64 fd511, fd509, fd510;
sub.f64 fd512, fd491, fd496;
mul.f64 fd513, fd512, 0d3FE904C37505DE4B;
sub.f64 fd514, fd492, fd495;
fma.rn.f64 fd515, fd514, 0d3FEF329C0558E969, fd513;
sub.f64 fd516, fd493, fd494;
fma.rn.f64 fd517, fd516, 0d3FDBC4C04D71ABC1, fd515;
mul.f64 fd518, fd497, 0d3FCC7B90E3024582;
sub.f64 fd519, fd483, fd518;
mul.f64 fd520, fd499, 0d3FECD4BCA9CB5C71;
sub.f64 fd521, fd519, fd520;
fma.rn.f64 fd522, fd501, 0d3FE3F3A0E28BEDD1, fd521;
mul.f64 fd523, fd512, 0d3FEF329C0558E969;
mul.f64 fd524, fd514, 0d3FDBC4C04D71ABC1;
sub.f64 fd525, fd523, fd524;
mul.f64 fd526, fd516, 0d3FE904C37505DE4B;
sub.f64 fd527, fd525, fd526;
mul.f64 fd528, fd497, 0d3FECD4BCA9CB5C71;
sub.f64 fd529, fd483, fd528;
fma.rn.f64 fd530, fd499, 0d3FE3F3A0E28BEDD1, fd529;
mul.f64 fd531, fd501, 0d3FCC7B90E3024582;
sub.f64 fd532, fd530, fd531;
mul.f64 fd533, fd512, 0d3FDBC4C04D71ABC1;
mul.f64 fd534, fd514, 0d3FE904C37505DE4B;
sub.f64 fd535, fd533, fd534;
fma.rn.f64 fd536, fd516, 0d3FEF329C0558E969, fd535;
fma.rn.f64 fd537, fd502, 0d3FE3F3A0E28BEDD1, fd490;
mul.f64 fd538, fd504, 0d3FCC7B90E3024582;
sub.f64 fd539, fd537, fd538;
mul.f64 fd540, fd506, 0d3FECD4BCA9CB5C71;
sub.f64 fd541, fd539, fd540;
sub.f64 fd542, fd484, fd489;
mul.f64 fd543, fd542, 0d3FE904C37505DE4B;
sub.f64 fd544, fd485, fd488;
fma.rn.f64 fd545, fd544, 0d3FEF329C0558E969, fd543;
sub.f64 fd546, fd486, fd487;
fma.rn.f64 fd547, fd546, 0d3FDBC4C04D71ABC1, fd545;
mul.f64 fd548, fd502, 0d3FCC7B90E3024582;
sub.f64 fd549, fd490, fd548;
mul.f64 fd550, fd504, 0d3FECD4BCA9CB5C71;
sub.f64 fd551, fd549, fd550;
fma.rn.f64 fd552, fd506, 0d3FE3F3A0E28BEDD1, fd551;
mul.f64 fd553, fd542, 0d3FEF329C0558E969;
mul.f64 fd554, fd544, 0d3FDBC4C04D71ABC1;
sub.f64 fd555, fd553, fd554;
mul.f64 fd556, fd546, 0d3FE904C37505DE4B;
sub.f64 fd557, fd555, fd556;
mul.f64 fd558, fd502, 0d3FECD4BCA9CB5C71;
sub.f64 fd559, fd490, fd558;
fma.rn.f64 fd560, fd504, 0d3FE3F3A0E28BEDD1, fd559;
mul.f64 fd561, fd506, 0d3FCC7B90E3024582;
sub.f64 fd562, fd560, fd561;
mul.f64 fd563, fd542, 0d3FDBC4C04D71ABC1;
mul.f64 fd564, fd544, 0d3FE904C37505DE4B;
sub.f64 fd565, fd563, fd564;
fma.rn.f64 fd566, fd546, 0d3FEF329C0558E969, fd565;
add.f64 %0, fd501, fd500;
add.f64 %1, fd506, fd505;
add.f64 %3, fd547, fd541;
sub.f64 %2, fd511, fd517;
sub.f64 %4, fd522, fd527;
add.f64 %5, fd557, fd552;
sub.f64 %6, fd532, fd536;
add.f64 %7, fd566, fd562;
add.f64 %8, fd536, fd532;
sub.f64 %9, fd562, fd566;
add.f64 %10, fd527, fd522;
sub.f64 %11, fd552, fd557;
sub.f64 %13, fd541, fd547;
add.f64 %12, fd517, fd511;
})"
     : "=d"(rmem[0].x), "=d"(rmem[0].y), "=d"(rmem[1].x), "=d"(rmem[1].y), "=d"(rmem[2].x), "=d"(rmem[2].y), "=d"(rmem[3].x), "=d"(rmem[3].y), "=d"(rmem[4].x), "=d"(rmem[4].y), "=d"(rmem[5].x), "=d"(rmem[5].y), "=d"(rmem[6].x), "=d"(rmem[6].y): "r"(smem), "l"(lut_dp_7_2401), "l"(lut_dp_7_343), "l"(lut_dp_7_49), "d"(rmem[0].x), "d"(rmem[0].y), "d"(rmem[1].x), "d"(rmem[1].y), "d"(rmem[1].y), "d"(rmem[2].x), "d"(rmem[2].y), "d"(rmem[2].y), "d"(rmem[3].x), "d"(rmem[3].y), "d"(rmem[4].x), "d"(rmem[4].y), "d"(rmem[4].y), "d"(rmem[5].x), "d"(rmem[5].y), "d"(rmem[5].y), "d"(rmem[6].x), "d"(rmem[6].y));
};


#endif
